"use client";
import React, { useEffect, useState } from "react";
import FormularioIngreso from "../formularioIngreso";
import { API_URL } from "../../../const";
import { ExclamationCircleIcon, CheckIcon } from "@heroicons/react/24/solid";
import Alert from "../../../components/alert";
import axios from "axios";

export default function ModalTerminos({ params }) {
  const [empresa, setEmpresa] = useState();
  const [error, setError] = useState(false);
  const [ip, setIP] = useState("");

  const [finFormulario, setFinFormulario] = useState(false);

  const finishFormulario = () => {
    setFinFormulario(true);
  };

  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await axios.get(
          API_URL + "/ingreso-empresa/formulario/" + params.token
        );
        // Procesa los datos de respuesta según sea necesario
        setEmpresa(response.data.empresa);
        if (response.data.aceptado) {
          setFinFormulario(response.data.aceptado);
        }
      } catch (error) {
        setError(true);
        console.error("Error fetching data:", error);
      }
    };

    const getIP = async () => {
      fetch("https://geolocation-db.com/json/")
        .then((response) => response.json())
        .then((data) => {
          setIP(data.IPv4);
        })
        .catch((error) => console.log(error));
    };

    getIP();
    fetchData();
  }, [params.token]);

  return (
    <section className="">
      <div className="text-2xl text-center">
        Formulario de inscripción y aceptación de términos
        {empresa && <p>{empresa.nombre_empresa}</p>}
      </div>

      {empresa && !finFormulario && (
        <div className="mt-6">
          <FormularioIngreso
            token={params.token}
            ip={ip}
            onFinish={finishFormulario}
          />
        </div>
      )}

      {error && (
        <div className="mt-4 text-2xl text-center">
          <Alert type="danger">
            <p className="text-red-200 flex gap-2 items-center">
              <ExclamationCircleIcon className="h-8 q w-8" />
              Formulario no existe o tiempo de validación expirado.
            </p>
          </Alert>
        </div>
      )}

      {finFormulario && (
        <div className="flex justify-center mt-4 text-2xl text-center">
          <p className="text-white flex gap-2 items-center">
            <CheckIcon className="h-8 q w-8" />
            ¡Formulario enviado con éxito!
          </p>
        </div>
      )}
    </section>
  );
}
